=begin
=窓/控えメンバーステータス




==更新履歴
  Date     Version Author Comment
==14/12/13 2.0.0   トリス 統合A～E B
==17/05/16 2.0.4   トリス 統合V～W V

=end

#==============================================================================
# ■ Window_BenchStatus
#==============================================================================
class Window_BenchStatus < Window_BattleStatus
  #--------------------------------------------------------------------------
  # ● ウィンドウを開く【オーバーライド】
  #--------------------------------------------------------------------------
  def open
    self.openness = 255
    self
  end
  #--------------------------------------------------------------------------
  # ● ウィンドウを閉じる【オーバーライド】
  #--------------------------------------------------------------------------
  def close
    self.openness = 0
    self
  end
  #--------------------------------------------------------------------------
  # ● 表示行数の取得
  #--------------------------------------------------------------------------
  def visible_line_number
    $game_party.bench_members.size.clamp(4, 14)
  end
  #--------------------------------------------------------------------------
  # ● 項目数の取得【オーバーライド】
  #--------------------------------------------------------------------------
  def item_max
    $game_party.bench_members.size
  end
  #--------------------------------------------------------------------------
  # ● 現在選択中のメンバー位置を取得【オーバーライド】
  #--------------------------------------------------------------------------
  def member_index
    return self.index + $game_party.max_battle_members
  end
  #--------------------------------------------------------------------------
  # ● 項目の描画【オーバーライド】
  #--------------------------------------------------------------------------
  def draw_item(index)
    actor = $game_party.bench_members[index]
    draw_basic_area(basic_area_rect(index), actor)
    draw_gauge_area(gauge_area_rect(index), actor)
  end
  #--------------------------------------------------------------------------
  # ● 選択項目の有効状態を取得
  #--------------------------------------------------------------------------
  def current_item_enabled?
    !(BattleManager.shift_change? && SceneManager.scene.no_change_all_dead_on_bench?)
  end
end
